/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: sst_prop.h
 * Author: Bernhard Holzinger 26.11.96
 * Purpose: System Test property set and get functions
 * ----------------------------------------------------------------------- */

#ifndef SST_PROP_H_INCLUDED
#define SST_PROP_H_INCLUDED

#include <sstdefs.h>


#ifdef __cplusplus
extern "C" {
#endif


CLI b_errtype EXPORT BestSstCfgPropSet(                             /* @sstcfgprpset */
                                       b_handletype handle,
				       b_sstcfgproptype sstcfgprop, /* @prop */
				       b_int32 value                /* @val */
                                       );

CLI b_errtype EXPORT BestSstCfgPropDefaultSet(                      /* @sstcfgprpdefset */
                                              b_handletype handle
					      );

CLI b_errtype EXPORT BestSstCfgPropGet(                             /* @sstcfgprpget */
                                       b_handletype handle,
				       b_sstcfgproptype sstcfgprop, /* @prop */
				       b_int32 *value               /* #RETURN "property value: %08lx\\h\n" */
				       );

CLI b_errtype EXPORT BestSstPropSet(                                /* @sstprpset */
                                    b_handletype handle,
				    b_sstproptype sstprop,          /* @prop */
				    b_int32 value                   /* @val */
				    );

CLI b_errtype EXPORT BestSstPropDefaultSet(                         /* @sstprpdefset */
                                           b_handletype handle
					   );

CLI b_errtype EXPORT BestSstPropGet(                                /* @sstprpget */
                                    b_handletype handle,
				    b_sstproptype sstprop,          /* @prop */
				    b_int32 *value                  /* #RETURN "property value: %08lx\\h\n" */
				    );
                          

#ifdef __cplusplus
}
#endif

#endif
